﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using GTA;

#if USING_XBOX_PAD
    using Microsoft.Xna.Framework.Input;
#endif

namespace NomeScripts
{    
    public class ControllerParser
    {
        public ControllerParser()
        {}

#if USING_XBOX_PAD
        public Buttons[] MapButtons(IniFile iniFile, String section, String action)
        {
            // Check for button combinations
            String[] stringArr = CheckForButtonCombo(iniFile.IniReadValue(section, action).Trim());

            // Create array of buttons for each action
            Buttons[] buttonArr = new Buttons[stringArr.Count()];

            // Iterate all buttons
            for (int i = 0; i < stringArr.Count(); ++i)
            {
                buttonArr[i] = StringToXboxButton(stringArr[i]);
            }

            return buttonArr;
        }

        public Buttons[] MapButtons(String buttonString)
        {
            // Check for button combinations
            String[] stringArr = CheckForButtonCombo(buttonString);

            // Create array of buttons for each action
            Buttons[] buttonArr = new Buttons[stringArr.Count()];

            // Iterate all buttons
            for (int i = 0; i < stringArr.Count(); ++i)
            {
                buttonArr[i] = StringToXboxButton(stringArr[i]);
            }

            return buttonArr;
        }

        public Buttons StringToXboxButton(String potentialButton)
        {
            Buttons button = (Microsoft.Xna.Framework.Input.Buttons)(-1);

            switch (potentialButton.Trim())
            {
                case "LB":
                    button = Buttons.LeftShoulder;
                    break;
                case "RB":
                    button = Buttons.RightShoulder;
                    break;
                case "DPAD_UP":
                    button = Buttons.DPadUp;
                    break;
                case "DPAD_DOWN":
                    button = Buttons.DPadDown;
                    break;
                case "DPAD_LEFT":
                    button = Buttons.DPadLeft;
                    break;
                case "DPAD_RIGHT":
                    button = Buttons.DPadRight;
                    break;
                case "BACK":
                    button = Buttons.Back;
                    break;
                case "START":
                    button = Buttons.Start;
                    break;
                case "HOME":
                    button = Buttons.BigButton;
                    break;
                case "Y":
                    button = Buttons.Y;
                    break;
                case "X":
                    button = Buttons.X;
                    break;
                case "B":
                    button = Buttons.B;
                    break;
                case "A":
                    button = Buttons.A;
                    break;
                case "LS":
                    button = Buttons.LeftStick;
                    break;
                case "RS":
                    button = Buttons.RightStick;
                    break;
                case "LS-Left":
                    button = Buttons.LeftThumbstickLeft;
                    break;
                case "LS-Up":
                    button = Buttons.LeftThumbstickUp;
                    break;
                case "LS-Right":
                    button = Buttons.LeftThumbstickRight;
                    break;
                case "LS-Down":
                    button = Buttons.LeftThumbstickDown;
                    break;
                case "RS-Left":
                    button = Buttons.RightThumbstickLeft;
                    break;
                case "RD-Up":
                    button = Buttons.RightThumbstickUp;
                    break;
                case "RS-Right":
                    button = Buttons.RightThumbstickRight;
                    break;
                case "RS-Down":
                    button = Buttons.RightThumbstickDown;
                    break;
                case "LT":
                    button = Buttons.LeftTrigger;
                    break;
                case "RT":
                    button = Buttons.RightTrigger;
                    break;
                default:
                    Game.Console.Print("ControllerParsing : XBOX360 button not recognised, " + potentialButton + ", NOT VALID!");
                    break;
            }

            return button;
        }

        public bool CheckButtonIsValid(Buttons button)
        {
            if (button == (Microsoft.Xna.Framework.Input.Buttons)(-1))
            {
                Game.Console.Print("ControllerParsing: Button is invalid! " + button.ToString());
                return false;
            }

            return true;
        } 
#endif

        public System.Windows.Forms.Keys StringToKeyboardKey(String potentialKey)
        {
            System.Windows.Forms.KeysConverter k = new System.Windows.Forms.KeysConverter();
            System.Windows.Forms.Keys key = System.Windows.Forms.Keys.None;

            try
            {
                if (potentialKey.Length == 1)
                {
                    potentialKey = potentialKey.ToUpper();
                }

                object obj = k.ConvertFromString(potentialKey);
                key = (System.Windows.Forms.Keys)obj;
            } catch (System.NotSupportedException) {
                Game.Console.Print("ControllerParsing: Keyboard button not recognised, " + potentialKey + ", NOT VALID!");
            }

            return key;
        }

        public bool CheckKeyIsValid(System.Windows.Forms.Keys key)
        {
            return !(key == System.Windows.Forms.Keys.None);
        }

        public String[] CheckForButtonCombo(string potentialCombo)
        {
            // Button combos must be comma delimited
            String[] comboButtons = potentialCombo.Split(',');

            return comboButtons;
        }
    }
}